/**
 * 
 */
package ibase.webitm.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;


/**
 * @author base
 *
 */
public class TemplateDetails 
{
	private static HashMap<String, TemplateDetails> templateDetails = null;
	//Added By Ravindra C on 20-06-18 for upload Utility - Start
	private HashMap<String, Object> objDetailMap = new HashMap<String, Object>();
	private final String COLUMN_SEPARATOR = ":";
	//Added By Ravindra C on 20-06-18 for upload Utility - End
	private HashMap<Integer, LinkedHashMap<String, String>> formWiseMapLogicData = null;
	private HashMap<Integer, LinkedHashMap<String, HashMap<String, String>>> formWiseDefineMapData = null;
	private HashMap<Integer, LinkedHashMap<String, String>> formWiseMapLogicValue = null;
	private HashMap<Integer, LinkedHashMap<String, String>> formWiseTargetCol = null;
	private HashMap<Integer, HashMap<String, HashMap<String, String>>> sheetMapDetailMap = null;
	private HashMap<Integer, HashMap<String, HashMap<String, String>>> formWiseDefineValueAllMap = null;
	
	private HashMap<Integer, HashMap<String, Integer>> matrixRowMap = null;
	private HashMap<Integer, String> sheetInfoMap = null;
	private HashMap<Integer, ArrayList<String>> excelColListMap = null;
	private HashMap<Integer, LinkedHashMap<String, String>> actualColMap = null;
	private HashMap<Integer, ArrayList<String>> actualColListMap = null;
	private HashMap<String, HashMap<String, String>> templateMap = null;
	//Added by Ravindra C on 27/12/2020 [to support json data upload]
	private HashMap<String, String> sheetDetailMap = null;
	
	//Added by Ravindra C on 08-02-19 to write Matrix And Normal Excel Errpor Information 
	private HashMap<String, Integer> matrixColSpanMap = null;  
	
	private int headingRowNo, matrixRowNo, startMatrixColNo, endMatrixColNo, dataStartsFrom;
	
	private E12GenericUtility genericUtility = null;
	
	/**
	 * 
	 */
	public TemplateDetails() 
	{
		genericUtility = new E12GenericUtility();
		
		formWiseMapLogicData = new HashMap<Integer, LinkedHashMap<String,String>>();
		formWiseDefineMapData = new HashMap<Integer, LinkedHashMap<String, HashMap<String,String>>>();
		formWiseMapLogicValue = new HashMap<Integer, LinkedHashMap<String,String>>();
		formWiseTargetCol = new HashMap<Integer, LinkedHashMap<String,String>>();
		sheetMapDetailMap = new HashMap<Integer, HashMap<String, HashMap<String, String>>>();
		matrixRowMap = new HashMap<Integer, HashMap<String,Integer>>();
		sheetInfoMap = new HashMap<Integer, String>();
		excelColListMap = new HashMap<Integer, ArrayList<String>>();
		actualColMap = new HashMap<Integer, LinkedHashMap<String, String>>();
		actualColListMap = new HashMap<Integer, ArrayList<String>>();
		templateMap = new HashMap<String, HashMap<String,String>>();
		formWiseDefineValueAllMap = new HashMap<Integer, HashMap<String,HashMap<String,String>>>();
		//Added by Ravindra C on 27/12/2020 [to support json data upload]
		sheetDetailMap = new HashMap<String, String>();
		
		headingRowNo = 1;
		matrixRowNo = -1;
		startMatrixColNo = -1;
		endMatrixColNo = -1;
		dataStartsFrom = 2;
	}
	
	public static TemplateDetails get( String templateKey )
	{
		try 
		{
			if ( templateDetails == null )
			{
				templateDetails = new HashMap<String, TemplateDetails>();
			}
			if( ! templateDetails.containsKey( templateKey ) )
			{
				templateDetails.put( templateKey, new TemplateDetails() );
			}
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		return templateDetails.get( templateKey );
	}
	
	/**
	 * 
	 * @return
	 */
	public HashMap<String, HashMap<String, String>> getTemplateMap()
	{
		System.out.println("TemplateDetail >> getTemplateMap ::"+templateMap);
		return templateMap;
	}
	
	/**
	 * 
	 * @param templateMap
	 */
	public void setTemplateMap( HashMap<String, HashMap<String, String>> templateMap )
	{
		System.out.println("TemplateDetail >> setTemplateMap ::"+templateMap);
		this.templateMap = templateMap;
	}
	
	/**
	 * 
	 * @param templateName
	 * @return
	 */
	public String getTemplateXml( String templateName )
	{
		String templateXml = null;
		System.out.println("TemplateDetail >> getTemplateXml ::"+templateName);
		System.out.println("TemplateDetail >> getTemplateXml ::"+templateMap);
		
		if ( templateMap != null && templateMap.containsKey( templateName ) )
		{
			templateXml = templateMap.get( templateName ).get( "TEMPLATE_XML_NEW" );
		}
		return templateXml;
	}
	
	/**
	 * 
	 * @param templateName
	 * @param templateXml
	 */
	public void setTemplateXml( String templateName, String templateXml )
	{
		System.out.println("TemplateDetail >> setTemplateXml ::"+templateName);
		System.out.println("TemplateDetail >> setTemplateXml ::"+templateMap);
		
		if ( templateMap != null && templateMap.containsKey( templateName ) )
		{
			templateMap.get( templateName ).put( "TEMPLATE_XML_NEW", templateXml );
		}
	}
	
	/**
	 * 
	 * @param templateName
	 * @return
	 */
	public boolean isDefaultTemplate( String templateName )
	{
		boolean isDefaultTemplate = false;
		if ( templateMap != null && templateMap.containsKey( templateName ) )
		{
			String defaultVal = templateMap.get( templateName ).get( "IS_DEFAULT" );
			if ( "Y".equalsIgnoreCase( defaultVal ) )
			{
				isDefaultTemplate = true;
			}
		}
		return isDefaultTemplate;
	}
	
	//Added By Ravindra C on 22-01-2021 [for auto confirm transaction from upload] START 
	public boolean isAutoConfirm( String templateName )
	{
		boolean isAutoConfirm = false;
		if ( templateMap != null && templateMap.containsKey( templateName ) )
		{
			String autoConfirmVal = templateMap.get( templateName ).get( "AUTO_CONFIRM" );
			if ( "Y".equalsIgnoreCase( autoConfirmVal ) )
			{
				isAutoConfirm = true;
			}
		}
		return isAutoConfirm;
	}
	//Added By Ravindra C on 22-01-2021 [for auto confirm transaction from upload] END
	
	/**
	 * 
	 * @param templateName
	 * @param isDefaultTemplate
	 */
	public void setDefaultTemplate( String templateName, String isDefaultTemplate )
	{
		if ( templateMap != null && templateMap.containsKey( templateName ) )
		{
			templateMap.get( templateName ).put( "IS_DEFAULT", isDefaultTemplate );
		}
	}
	
	/**
	 * 
	 * @param templateName
	 * @return
	 */
	public String getFileMapping( String templateName )
	{
		String fileMapping = null;
		System.out.println("TemplateDetail >> getFileMapping ::"+templateName);
		System.out.println("TemplateDetail >> getFileMapping ::"+templateMap);
		
		System.out.println("TemplateDetail >> templateMap.containsKey( templateName ) ::"+templateMap.containsKey( templateName ));
		
		if ( templateMap != null && templateMap.containsKey( templateName ) )
		{
			fileMapping = templateMap.get( templateName ).get( "FILE_MAPPING" );
		}
		return fileMapping;
	}
	
	/**
	 * 
	 * @param templateName
	 * @param mappingXml
	 */
	public void setFileMapping( String templateName, String mappingXml )
	{
		System.out.println("TemplateDetail >> setFileMapping ::"+templateName);
		System.out.println("TemplateDetail >> setFileMapping ::"+mappingXml);
		System.out.println("TemplateDetail >> setFileMapping ::"+templateMap);
		
		if ( templateMap != null && templateMap.containsKey( templateName ) )
		{
			templateMap.get( templateName ).put( "FILE_MAPPING", mappingXml );
		}
	}
	
	/**
	 * 
	 * @param templateName
	 * @return
	 */
	public String getTemplateId( String templateName )
	{
		String templateId = null;
		System.out.println("TemplateDetail >> getTemplateId ::"+templateName);
		System.out.println("TemplateDetail >> getTemplateId ::"+templateMap);
		
		if ( templateMap != null && templateMap.containsKey( templateName ) )
		{
			templateId = templateMap.get( templateName ).get( "TEMPLATE_ID" );
		}
		System.out.println("TemplateDetail >> getTemplateId ::"+templateId);
		return templateId;
	}
	
	/**
	 * 
	 * @param templateName
	 * @return
	 */
	public String getShareScope( String templateName )
	{
		String shareScope = null;
		if ( templateMap != null && templateMap.containsKey( templateName ) )
		{
			shareScope = templateMap.get( templateName ).get( "SHARE_SCOPE" );
		}
		return shareScope;
	}
	
	/**
	 * 
	 * @param templateName
	 * @return
	 */
	public String getScopeValue( String templateName )
	{
		String scopeValue = null;
		if ( templateMap != null && templateMap.containsKey( templateName ) )
		{
			scopeValue = templateMap.get( templateName ).get( "SCOPE_VALUE" );
		}
		return scopeValue;
	}
	
	/**
	 * 
	 * @param templateName
	 * @return
	 */
	public String getAddUser( String templateName )
	{
		String addUser = null;
		if ( templateMap != null && templateMap.containsKey( templateName ) )
		{
			addUser = templateMap.get( templateName ).get( "ADD_USER" );
		}
		return addUser;
	}
	
	/**
	 * 
	 * @param templateName
	 * @return
	 */
	public String getChgUser( String templateName )
	{
		String chgUser = null;
		if ( templateMap != null && templateMap.containsKey( templateName ) )
		{
			chgUser = templateMap.get( templateName ).get( "CHG_USER" );
		}
		return chgUser;
	}
	
	/**
	 * 
	 * @return
	 */
	public String getDefaultTemplate()
	{
		String defaultTemplate = "";
		if ( templateMap != null )
		{
			for ( Map.Entry<String, HashMap<String, String>> entry : templateMap.entrySet() )
			{
				String templateName = entry.getKey();
				if ( isDefaultTemplate( templateName ) )
				{
					String defaultTempData = checkNull( getTemplateXml( templateName ) );
					if ( defaultTempData.length() > 0 )
					{
						defaultTemplate = templateName;
						break;
					}
				}
			}
		}
		return defaultTemplate;
	}
	
	/**
	 * 
	 * @param templateXml
	 * @param totalForms
	 */
	public void createTemplateDetail( String templateXml, int totalForms )
	{
		BaseLogger.log("3", null, null,"tempxml - [" + templateXml +"]");
		String targetColName = "";
		String srcColName = "";
		Node dataNode = null;
		try 
		{
			LinkedHashMap<String, String> mapLogicData = null;
			LinkedHashMap<String, HashMap<String, String>> defineMapData = null;
			LinkedHashMap<String, String> mapLogicValue = null;
			LinkedHashMap<String, String> targetColMap = null;
			HashMap<String, HashMap<String, String>> innerMap = null;

			templateXml = templateXml.replaceAll( "\n", "" );
			templateXml = templateXml.replaceAll( "\t", "" );
			templateXml = templateXml.replaceAll( "\r", "" );
			Document templateDom = genericUtility.parseString( templateXml );
			Element docEle = templateDom.getDocumentElement();
			NodeList dataNodes = docEle.getChildNodes();
			for ( int formNo = 1; formNo <= totalForms; formNo++ )
			{
				mapLogicData = new LinkedHashMap<String, String>();
				defineMapData = new LinkedHashMap<String, HashMap<String, String>>();
				mapLogicValue = new LinkedHashMap<String, String>();
				targetColMap = new LinkedHashMap<String, String>();
				innerMap = new HashMap<String, HashMap<String, String>>();
				BaseLogger.log("3", null, null,"TAB NO ::::: " + formNo);
				for ( int j = 0; j < dataNodes.getLength(); j++ )
				{
					dataNode = dataNodes.item(j);
					String nodeName = dataNodes.item(j).getNodeName();
					//Commented By Ravindra C on 06-09-18 for prevent SYSOUT.
					//BaseLogger.log("9", null, null,"nodeName - [" + nodeName +"], j - ["+ j +"]");
					//Changed By Ravindra C on 21-02-18
					//if ( nodeName.equals("DETAIL" + formNo) ) 
					if ( !(nodeName.equalsIgnoreCase("#text")) && nodeName.equals("DETAIL" + formNo) ) 
					{
						NodeList dataNodeList = dataNode.getChildNodes();
						int dataNodesLen = dataNodeList.getLength();
						//Commented By Ravindra C on 06-09-18 for prevent SYSOUT.
						//BaseLogger.log("9", null, null,"dataNodesLen - [" + dataNodesLen +"]");
						for (int i = 0; i < dataNodesLen; i++) 
						{
							//Commented By Ravindra C on 06-09-18 for prevent SYSOUT.
							//BaseLogger.log("9", null, null,"RUNNING");
							Node curStatusNode = dataNodeList.item(i);
							NodeList dataNodList = curStatusNode.getChildNodes();
							int dataNodListLen = dataNodList.getLength();
							//Commented By Ravindra C on 06-09-18 for prevent SYSOUT.
							//BaseLogger.log("9", null, null,"dataNodListLen - [" + dataNodListLen +"], i - ["+ i +"]");
							String mapLogicNodeName = "";
							String mapLogicNodeValue = "";
							String mapLogic = "";
							for (int ctr = 0; ctr < dataNodListLen; ctr++) 
							{
								dataNode = dataNodList.item(ctr);
								String dataNodeName = dataNode.getNodeName();
								//Commented By Ravindra C on 06-09-18 for prevent SYSOUT.
								//BaseLogger.log("9", null, null,"dataNodeName - [" + dataNodeName +"], ctr - ["+ ctr +"]");
								if ("SRC_COL".equalsIgnoreCase(dataNodeName)) 
								{
									srcColName = dataNode.getFirstChild().getNodeValue();
								}
								else if ("TARGET_COL".equals(dataNodeName)) 
								{
									targetColName = dataNode.getFirstChild().getNodeValue();
								}
								else if ("MAP_LOGIC".equals(dataNodeName))
								{
									Element element = (Element) dataNodList.item(ctr);
									mapLogic = element.getAttribute("TYPE");
									if ( ! "A".equals( mapLogic ) )
									{
										HashMap<String, String> internalMap = new LinkedHashMap<String, String>();
										HashMap<String, String> mapData = new LinkedHashMap<String, String>();
										NodeList childNodeList = element.getChildNodes();
										int childNodeLen = childNodeList.getLength();
										for (int k = 0; k < childNodeLen; k++)
										{
											Node currNode1 = childNodeList.item( k );
											//Commented By Ravindra C on 06-09-18 for prevent SYSOUT.
											//BaseLogger.log("9", null, null,"currNode1.getNodeName() --- [" + currNode1.getNodeName() + "]");
											mapLogicNodeName = "";
											mapLogicNodeValue = "";
											if ( currNode1 != null && ! ( currNode1.getNodeName().equalsIgnoreCase("#text") ) )
											{
												if ("D".equals(mapLogic)) 
												{
													Element childElement = (Element) childNodeList.item(k);
													mapLogicNodeName = childElement.getAttribute("KEY");
													if ( childElement.getFirstChild() != null )
													{
														mapLogicNodeValue = childElement.getFirstChild().getNodeValue();
													}
													
													mapData.put( mapLogicNodeName, mapLogicNodeValue );
													defineMapData.put( srcColName, mapData );
												}
												else
												{
													Node childNode = childNodeList.item(k);
													mapLogicNodeName = childNode.getNodeName();
													if ( childNode.getFirstChild() != null )
													{
														mapLogicNodeValue = childNode.getFirstChild().getNodeValue();
													}
													
													mapLogicValue.put( mapLogicNodeName +"_"+ srcColName, mapLogicNodeValue );
												}
												BaseLogger.log("3", null, null, "mapLogicNodeName ["+ mapLogicNodeName +"]" );
												BaseLogger.log("3", null, null, "mapLogicNodeValue ["+ mapLogicNodeValue +"]" );
												internalMap.put( mapLogicNodeName, mapLogicNodeValue );
											}
										}
										innerMap.put( srcColName, internalMap );
									}
								}
							}
							mapLogicData.put( srcColName, mapLogic );
							targetColMap.put( srcColName, targetColName );
						}
					}
				}
				formWiseMapLogicData.put( formNo, mapLogicData );
				formWiseDefineMapData.put( formNo, defineMapData );
				formWiseMapLogicValue.put( formNo, mapLogicValue );
				formWiseTargetCol.put( formNo, targetColMap );
				sheetMapDetailMap.put( formNo, innerMap );
			}
			BaseLogger.log("3", null, null, "formWiseMapLogicData - ["+ formWiseMapLogicData +"]" );
			BaseLogger.log("3", null, null, "formWiseDefineMapData - ["+ formWiseDefineMapData +"]" );
			BaseLogger.log("3", null, null, "formWiseMapLogicValue - ["+ formWiseMapLogicValue +"]" );
			BaseLogger.log("3", null, null, "formWiseTargetCol - ["+ formWiseTargetCol +"]" );
			BaseLogger.log("3", null, null, "sheetMapDetailMap - ["+ sheetMapDetailMap +"]" );
		}
		catch (Exception e)
		{
			e.printStackTrace();
			BaseLogger.log("0", null, null,"Exception buildTemplateDetailMap : ["+ e.getMessage() +"]");
		}
	}

	/**
	 * @return the formWiseMapLogicData
	 */
	public HashMap<Integer, LinkedHashMap<String, String>> getFormWiseMapLogicData() 
	{
		return formWiseMapLogicData;
	}
	
	/**
	 * 
	 * @param formNo
	 * @return
	 */
	public LinkedHashMap<String, String> getMapLogicData( int formNo ) 
	{
		LinkedHashMap<String, String> mapLogicData = null;
		if ( formWiseMapLogicData != null )
		{
			mapLogicData = formWiseMapLogicData.get( formNo );
		}
		return mapLogicData;
	}

	/**
	 * @return the formWiseDefineMapData
	 */
	public HashMap<Integer, LinkedHashMap<String, HashMap<String, String>>> getFormWiseDefineMapData() 
	{
		return formWiseDefineMapData;
	}
	
	/**
	 * 
	 * @param formNo
	 * @return
	 */
	public LinkedHashMap<String, HashMap<String, String>> getDefineMapData( int formNo ) 
	{
		LinkedHashMap<String, HashMap<String, String>> defineMapData = null;
		if ( formWiseDefineMapData != null )
		{
			defineMapData = formWiseDefineMapData.get( formNo );
		}
		return defineMapData;
	}

	/**
	 * @return the formWiseMapLogicValue
	 */
	public HashMap<Integer, LinkedHashMap<String, String>> getFormWiseMapLogicValue() 
	{
		return formWiseMapLogicValue;
	}
	
	/**
	 * @param formWiseMapLogicValue the formWiseMapLogicValue to set
	 */
	public void setFormWiseMapLogicValue(HashMap<Integer, LinkedHashMap<String, String>> formWiseMapLogicValue) 
	{
		this.formWiseMapLogicValue = formWiseMapLogicValue;
	}

	/**
	 * 
	 * @param formNo
	 * @return
	 */
	public LinkedHashMap<String, String> getMapLogicValue( int formNo ) 
	{
		LinkedHashMap<String, String> mapLogicValue = null;
		if ( formWiseMapLogicValue != null )
		{
			mapLogicValue = formWiseMapLogicValue.get( formNo );
		}
		return mapLogicValue;
	}

	/**
	 * @return the formWiseTargetCol
	 */
	public HashMap<Integer, LinkedHashMap<String, String>> getFormWiseTargetCol() 
	{
		return formWiseTargetCol;
	}
	
	/**
	 * 
	 * @param formNo
	 * @return
	 */
	public LinkedHashMap<String, String> getTargetCol( int formNo ) 
	{
		LinkedHashMap<String, String> targetColMap = null;
		if ( formWiseTargetCol != null )
		{
			targetColMap = formWiseTargetCol.get( formNo );
		}
		return targetColMap;
	}
	
	/**
	 * @return the sheetMapDetailMap
	 */
	public HashMap<Integer, HashMap<String, HashMap<String, String>>> getSheetMapDetailMap() 
	{
		return sheetMapDetailMap;
	}
	
	/**
	 * 
	 * @param formNo
	 * @return
	 */
	public HashMap<String, HashMap<String, String>> getSheetMapDetail( int formNo ) 
	{
		HashMap<String, HashMap<String, String>> sheetMapDetail = null;
		if ( sheetMapDetailMap != null )
		{
			sheetMapDetail = sheetMapDetailMap.get( formNo );
		}
		return sheetMapDetail;
	}

	/**
	 * @return the formWiseDefineValueAllMap
	 */
	public HashMap<Integer, HashMap<String, HashMap<String, String>>> getFormWiseDefineValueAllMap() 
	{
		return formWiseDefineValueAllMap;
	}

	/**
	 * @param formWiseDefineValueAllMap the formWiseDefineValueAllMap to set
	 */
	public void setFormWiseDefineValueAllMap(HashMap<Integer, HashMap<String, HashMap<String, String>>> formWiseDefineValueAllMap) 
	{
		this.formWiseDefineValueAllMap = formWiseDefineValueAllMap;
	}

	/**
	 * 
	 * @param formNo
	 * @return
	 */
	public HashMap<String, HashMap<String, String>> getDefineValueAllMap( int formNo ) 
	{
		HashMap<String, HashMap<String, String>> defineValueAllMap = null;
		if ( formWiseDefineValueAllMap != null )
		{
			defineValueAllMap = formWiseDefineValueAllMap.get( formNo );
		}
		return defineValueAllMap;
	}

	/**
	 * 
	 * @param fileMappingXml
	 */
	public void createFileMappingDetail( String fileMappingXml )
	{
		try 
		{
			if ( fileMappingXml != null && fileMappingXml.length() > 0 )
			{
				fileMappingXml = fileMappingXml.replaceAll( "\n", "" );
				fileMappingXml = fileMappingXml.replaceAll( "\t", "" );
				Document fileMappingDom = genericUtility.parseString( fileMappingXml );
				Node parentNode = null;
				NodeList childNodeList = null;
				Node childNode = null;
				if ( fileMappingDom != null )
				{
					NodeList parentNodeList = fileMappingDom.getElementsByTagName("ROOT").item( 0 ).getChildNodes();
					if ( parentNodeList != null && parentNodeList.getLength() > 0 ) 
					{
						//Added By Ravindra C on 21-02-18
						int counter = 0;
						BaseLogger.log("3", null, null, "parentNodeList.getLength() - ["+ parentNodeList.getLength() +"]" );
						for (int i = 0; i < parentNodeList.getLength(); i++) 
						{
							parentNode = parentNodeList.item(i);
							//Added By Ravindra C on 21-02-18
							if( ! parentNode.equals("#text") )
							{
								BaseLogger.log("3", null, null, "parentNode - ["+ parentNode.getNodeName() +"]" );
								childNodeList = parentNode.getChildNodes();
								BaseLogger.log("3", null, null, "childNodeList.getLength() - ["+ childNodeList.getLength() +"]" );
								HashMap<String, Integer> matrixValueMap = new HashMap<String, Integer>();
								int headingRowNum = 1, matrixRowNum = -1, startMatrixColNum = -1, endMatrixColNum = -1, dataStartsFrom = 2, colSpan = 0;
								String sheetName = "";
								for ( int j = 0; j < childNodeList.getLength(); j++ ) 
								{
									childNode = childNodeList.item(j);
									if ( childNode != null )
									{
										String childNodeName = childNode.getNodeName();
										String childNodeVal = "";
										//Changed By Ravindra C on 21-02-18
										//if ( childNode.getChildNodes() != null && childNode.getChildNodes().item( 0 ) != null )
										if ( ! ( childNodeName.equalsIgnoreCase("#text") ) && childNode.getChildNodes() != null && childNode.getChildNodes().item( 0 ) != null )
										{
											childNodeVal = checkNull( childNode.getChildNodes().item(0).getNodeValue() );
											BaseLogger.log("3", null, null, "childNodeName - ["+ childNodeName +"], childNodeVal - ["+ childNodeVal +"]" );
											if ( childNodeVal.length() > 0 )
											{
												if ( "HEADING_ROW".equalsIgnoreCase( childNodeName ) )
												{
													headingRowNum = Integer.parseInt( childNodeVal );
													headingRowNum -= 1;
												}
												else if ( "DATA_STARTS_FROM_ROW".equalsIgnoreCase( childNodeName ) )
												{
													dataStartsFrom = Integer.parseInt( childNodeVal );
													dataStartsFrom -= 1;
												}
												else if ( "MATRIX_HEADER_ROW".equalsIgnoreCase( childNodeName ) )
												{
													matrixRowNum = Integer.parseInt( childNodeVal );
													matrixRowNum -= 1;
												}
												else if ( "MATRIX_START_COL".equalsIgnoreCase( childNodeName ) )
												{
													startMatrixColNum = Integer.parseInt( childNodeVal );
													startMatrixColNum -= 1;
												}
												else if ( "MATRIX_END_COL".equalsIgnoreCase( childNodeName ) )
												{
													endMatrixColNum = Integer.parseInt( childNodeVal );
													endMatrixColNum -= 1;
												}
												else if ( "SHEETNAME".equalsIgnoreCase( childNodeName ) )
												{
													sheetName = childNodeVal;
												}
												//Added By Ravindra C on 25-04-19  to validate matrix Excel template against selected excel file -Start 
												else if ( "COL_SPAN".equalsIgnoreCase( childNodeName ) )
												{
													colSpan = Integer.parseInt( childNodeVal );;
												}
												//Added By Ravindra C on 25-04-19  to validate matrix Excel template against selected excel file -End
											}
										}
									}
								}
								matrixValueMap.put( "HEADING_ROW", headingRowNum ); //Heading Row No - [0]
								matrixValueMap.put( "MATRIX_HEADER_ROW", matrixRowNum ); //Matrix Row No - [1]
								matrixValueMap.put( "MATRIX_START_COL", startMatrixColNum ); //Start Matrix Column No - [2]
								matrixValueMap.put( "MATRIX_END_COL", endMatrixColNum ); //End Matrix Column No - [3]
								matrixValueMap.put( "DATA_STARTS_FROM_ROW", dataStartsFrom ); //Data Start From - [4]
								//Added By Ravindra C on 25-04-19  to validate matrix Excel template against selected excel file 
								matrixValueMap.put( "COL_SPAN", colSpan );

								BaseLogger.log("3", null, null, "matrixValueList - "+ matrixValueMap );

								int formNo = (counter + 1);
								matrixRowMap.put( formNo, matrixValueMap );

								BaseLogger.log("3", null, null, "sheetName - ["+ sheetName +"]" );
								sheetInfoMap.put( formNo, sheetName );
								//Added by Ravindra C on 27/12/2020 [to support json data upload]
								sheetDetailMap.put( sheetName, ("Detail"+ formNo) );
								//Added by Ravindra C on 21-02-18 [Start]	
								counter++;
							}
							else
							{
								counter = 0;
							}
							//Added by Ravindra C on 21-02-18 [End]	
						}
					}
				}
				BaseLogger.log("3", null, null, "matrixRowMap - ["+ matrixRowMap +"]" );
				BaseLogger.log("3", null, null, "sheetInfoMap - ["+ sheetInfoMap +"]" );
				BaseLogger.log("3", null, null, "sheetDetailMap - ["+ sheetDetailMap +"]" );
			}
		}
		catch (Exception e) 
		{
			BaseLogger.log("0", null, null, "Exception in setFileMapping - ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
	}
	
	/**
	 * 
	 * @return
	 */
	public HashMap<Integer, HashMap<String, Integer>> getFormWiseMatrixRowMap()
	{
		return matrixRowMap;
	}
	
	/**
	 * 
	 * @param formNo
	 * @return
	 */
	public HashMap<String, Integer> getMatrixValueMap( int formNo ) 
	{
		HashMap<String, Integer> matrixValueMap = null;
		if ( matrixRowMap != null )
		{
			matrixValueMap = matrixRowMap.get( formNo );
		}
		return matrixValueMap;
	}
	
	/**
	 * 
	 * @return
	 */
	public HashMap<Integer, String> getSheetInfoMap()
	{
		return sheetInfoMap;
	}
	
	/**
	 * 
	 * @param formNo
	 * @return
	 */
	public String getSheetName( int formNo ) 
	{
		String sheetName = null;
		if ( sheetInfoMap != null )
		{
			sheetName = sheetInfoMap.get( formNo );
		}
		return sheetName;
	}
	
	/**
	 * 
	 * @param nullStr
	 * @return
	 */
	private String checkNull( String nullStr )
	{
		return E12GenericUtility.checkNull( nullStr );
	}

	/**
	 * @return the excelColListMap
	 */
	public HashMap<Integer, ArrayList<String>> getExcelColListMap() 
	{
		return excelColListMap;
	}
	
	/**
	 * 
	 * @param formNo
	 * @return
	 */
	public ArrayList<String> getExcelColList( int formNo ) 
	{
		ArrayList<String> excelColList = null;
		if ( excelColListMap != null )
		{
			excelColList = excelColListMap.get( formNo );
		}
		return excelColList;
	}

	/**
	 * @param excelColListMap the excelColListMap to set
	 */
	public void setExcelColListMap(HashMap<Integer, ArrayList<String>> excelColListMap) 
	{
		this.excelColListMap = excelColListMap;
	}

	/**
	 * @return the actualColListMap
	 */
	public HashMap<Integer, LinkedHashMap<String, String>> getActualColMap() 
	{
		return actualColMap;
	}
	
	/**
	 * 
	 * @param formNo
	 * @return
	 */
	public LinkedHashMap<String, String> getActualCol( int formNo ) 
	{
		LinkedHashMap<String, String> actualCol = null;
		if ( actualColMap != null )
		{
			actualCol = actualColMap.get( formNo );
		}
		return actualCol;
	}

	/**
	 * @param actualColListMap the actualColListMap to set
	 */
	public void setActualColMap(HashMap<Integer, LinkedHashMap<String, String>> actualColMap) 
	{
		this.actualColMap = actualColMap;
	}

	/**
	 * @return the actualColListMap
	 */
	public HashMap<Integer, ArrayList<String>> getActualColListMap() 
	{
		return actualColListMap;
	}
	
	/**
	 * @param actualColListMap the actualColListMap to set
	 */
	public void setActualColListMap(HashMap<Integer, ArrayList<String>> actualColListMap) 
	{
		this.actualColListMap = actualColListMap;
	}

	/**
	 * 
	 * @param formNo
	 * @return
	 */
	public ArrayList<String> getActualColList( int formNo ) 
	{
		ArrayList<String> actualColList = null;
		if ( actualColListMap != null )
		{
			actualColList = actualColListMap.get( formNo );
		}
		return actualColList;
	}
	
	/**
	 * @return the headingRowNo
	 */
	public int getHeadingRowNo( int formNo ) 
	{
		if ( matrixRowMap != null )
		{
			headingRowNo = matrixRowMap.get( formNo ).get( "HEADING_ROW" );
		}
		return headingRowNo;
	}

	/**
	 * @return the matrixRowNo
	 */
	public int getMatrixRowNo( int formNo ) 
	{
		if ( matrixRowMap != null )
		{
			matrixRowNo = matrixRowMap.get( formNo ).get( "MATRIX_HEADER_ROW" );
		}
		return matrixRowNo;
	}
	//Added By Ravindra C on 25-04-19  to validate matrix Excel template against selected excel file -Start 
	public int getSheetColSpan( int formNo ) 
	{
		int colSpan = 0;
		if ( matrixRowMap != null )
		{
			colSpan = matrixRowMap.get( formNo ).get( "COL_SPAN" );
		}
		return colSpan;
	}
	//Added By Ravindra C on 25-04-19  to validate matrix Excel template against selected excel file - End

	/**
	 * @return the startMatrixColNo
	 */
	public int getStartMatrixColNo( int formNo ) 
	{
		if ( matrixRowMap != null )
		{
			startMatrixColNo = matrixRowMap.get( formNo ).get( "MATRIX_START_COL" );
		}
		return startMatrixColNo;
	}

	/**
	 * @return the endMatrixColNo
	 */
	public int getEndMatrixColNo( int formNo ) 
	{
		if ( matrixRowMap != null )
		{
			endMatrixColNo = matrixRowMap.get( formNo ).get( "MATRIX_END_COL" );
		}
		return endMatrixColNo;
	}

	/**
	 * @return the dataStartsFrom
	 */
	public int getDataStartsFrom( int formNo ) 
	{
		if ( matrixRowMap != null )
		{
			dataStartsFrom = matrixRowMap.get( formNo ).get( "DATA_STARTS_FROM_ROW" );
		}
		return dataStartsFrom;
	}
	
	public ArrayList<Integer> getTotalRowsInTemplate( String templateName )
	{
		ArrayList<Integer> sheetsUsed = new ArrayList<Integer>();
		try 
		{
			String nodeName = "";
			int tabNo = 0;

			String templateXml = getTemplateXml( templateName );
			Document doc = genericUtility.parseString( templateXml );
			Element docEle = doc.getDocumentElement();
			NodeList detailNodes = docEle.getChildNodes();
			int detailNodeLength = detailNodes.getLength();
			BaseLogger.log("3", null, null,"detailNodes.getLength() [" + detailNodeLength + "]");

			for ( int i = 0; i < detailNodeLength; i++ ) 
			{
				Node currNode = detailNodes.item( i );
				if ( currNode != null && ! ( currNode.getNodeName().equalsIgnoreCase("#text") ) )
				{
					nodeName = currNode.getNodeName();
					BaseLogger.log("3", null, null, "currNode.getNodeName() ["+ nodeName +"]" );
					tabNo = Integer.parseInt( nodeName.substring(6) );
					BaseLogger.log("3", null, null,"tabNo [" + tabNo + "]");
					sheetsUsed.add(tabNo);
				}
			}
			BaseLogger.log("3", null, null,"SHEETS USED IN TEMPLATE : " + sheetsUsed);
		}
		catch (NumberFormatException e) 
		{
			e.printStackTrace();
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		return sheetsUsed;
	}
	//Added by Ajinkya D on 16-NOV-2017 [For Upload Utility] [START]
	public String getDocId(String templateName)
	{
		String docId = null;
		if ( templateMap != null && templateMap.containsKey( templateName ) ) 
		{
			docId = templateMap.get(templateName).get("TEMP_DOC_ID");
		}
		return docId;
	}

	public String getTempRightsChar(String templateName)
	{
		String rightsChar = null;
		if ( templateMap != null && templateMap.containsKey( templateName ) ) 
		{
			rightsChar = templateMap.get(templateName).get("TEMP_RIGHTS_CHAR");
		}
		return rightsChar;
	}
	//Added by Ajinkya D on 16-NOV-2017 [For Upload Utility] [END]

	//Added By Ravindra C on 20-06-18 for upload Utility - Start
	/**
	 * @return the objDetailMap
	 */
	public HashMap<String, Object> getObjDetailMap() 
	{
		return objDetailMap;
	}

	/**
	 * @param objDetailMap the objDetailMap to set
	 */
	public void setObjDetailMap(HashMap<String, Object> objDetailMap) 
	{
		this.objDetailMap = objDetailMap;
	}
	
	/**
	 * get transetup details
	 * 
	 * @param fieldName
	 * @return
	 */
	public String getTransetupDetail( String fieldName )
	{
		if ( objDetailMap != null && objDetailMap.get( "TRANSETUP" ) != null )
		{
			return ((HashMap<String, String>) objDetailMap.get( "TRANSETUP" )).get( fieldName );
		}
		return null;
	}
	
	/**
	 * get formwise pkField Name List
	 * 
	 * @param formNo
	 * @return
	 */
	public ArrayList<String> getPKFieldNameList( String formNo )
	{
		if ( objDetailMap != null && objDetailMap.get( "PK_NAME" ) != null )
		{
			String pkFieldName = ((HashMap<String, String>)objDetailMap.get( "PK_NAME" )).get( formNo );
			if ( pkFieldName != null )
			{
				ArrayList<String> pkNameList = new ArrayList<String>( Arrays.asList( pkFieldName.split( COLUMN_SEPARATOR ) ) );
				return pkNameList;
			}
		}
		return null;
	}
	
	/**
	 * get form name from OBJ_FORMS
	 * 
	 * @param formNo
	 * @return
	 */
	public String getFormName( String formNo )
	{
		if ( objDetailMap != null && objDetailMap.get( "FORM_NAME" ) != null )
		{
			return ((HashMap<String, String>)objDetailMap.get( "FORM_NAME" )).get( formNo );
		}
		return null;
	}
	
	/**
	 * Get form count
	 * 
	 * @return
	 */
	public int getFormCount()
	{
		if ( objDetailMap != null && objDetailMap.get( "FORM_NAME" ) != null )
		{
			return ((HashMap<String, String>)objDetailMap.get( "FORM_NAME" )).size();
		}
		return 0;
	}
	
	/**
	 * get column size map
	 * 
	 * @param formNo
	 * @return
	 */
	public HashMap<String, Integer> getColumnSize( String formNo )
	{
		if ( objDetailMap != null && objDetailMap.get( "COLUMN_SIZE" ) != null )
		{
			return ((HashMap<String, HashMap<String, Integer>>)objDetailMap.get( "COLUMN_SIZE" )).get( formNo );
		}
		return null;
	}
	
	/**
	 * get column type map
	 * 
	 * @param formNo
	 * @return
	 */
	public HashMap<String, String> getColumnTypeDB( String formNo )
	{
		if ( objDetailMap != null && objDetailMap.get( "COLUMN_TYPE_DB" ) != null )
		{
			return ((HashMap<String, HashMap<String, String>>)objDetailMap.get( "COLUMN_TYPE_DB" )).get( formNo );
		}
		return null;
	}
	//Added By Ravindra C on 20-06-18 for upload Utility - End
	
	//Added By Ravindra C on 20-07-2020 for data and datetime validation through metadata file - Start 
	public HashMap<String, String> getColumnTypeMetaDeta( String formNo )
	{
		if ( objDetailMap != null && objDetailMap.get( "COLUMN_TYPE_METADATA" ) != null )
		{
			return ((HashMap<String, HashMap<String, String>>)objDetailMap.get( "COLUMN_TYPE_METADATA" )).get( formNo );
		}
		return null;
	}
	//Added By Ravindra C on 20-07-2020 for data and datetime validation through metadata file - Start
	
	//Added By Ravindra C on 08-09-18 for upload Utility - End
	public HashMap<String, HashMap<String, String>> getDropDownColValueMap( String formNo )
	{
		if ( objDetailMap != null && objDetailMap.get( "COLUMN_TYPE_VALUES" ) != null )
		{
			return ((HashMap<String, HashMap<String, HashMap<String, String>>>) objDetailMap.get( "COLUMN_TYPE_VALUES" )).get( formNo );
		}
		return null;
	}
	//Added By Ravindra C on 08-09-18 for upload Utility - End
	
	//Added By Ravindra C on 20-11-18 to create file case value map. -Start
	public HashMap<String, String> getFieldCase( String formNo )
	{
		if ( objDetailMap != null && objDetailMap.get( "COLUMN_SIZE" ) != null )
		{
			return ((HashMap<String, HashMap<String, String>>)objDetailMap.get( "FIELD_CASE_VALUES" )).get( formNo );
		}
		return null;
	}
	//Added By Ravindra C on 20-11-18 to create file case value map. - End

	//added By Ravindra C on 06-11-18 to get Template RightChar - Start
	public String getRightChar( String templateName )
	{
		String rightChar = null;
		if ( templateMap != null && templateMap.containsKey( templateName ) ) 
		{
			rightChar = templateMap.get( templateName ).get("RIGHTS");
		}
		return rightChar;
	}
	//added By Ravindra C on 06-11-18 to get Template RightChar - End.

	//Added by Ravindra C on 13-12-18 to get field value precision information . - Start
	public HashMap<String, Integer> getColumnPrecision( String formNo )
	{
		if ( objDetailMap != null && objDetailMap.get( "FIELD_PRECISION_VALUES" ) != null )
		{
			return ((HashMap<String, HashMap<String, Integer>>)objDetailMap.get( "FIELD_PRECISION_VALUES" )).get( formNo );
		}
		return null;
	}
	//Added by Ravindra C on 13-12-18 to get field value precision information . - End

   //added by Ravindra C on 01-02-19 to write matrix error file - Start
	public int getMatrixColSpan( String sheetName )
	{
		int matrixColSpan = 0;
		if ( matrixColSpanMap != null && matrixColSpanMap.containsKey( sheetName ))
		{
			matrixColSpan = matrixColSpanMap.get( sheetName );
		}
		return matrixColSpan;
	}
	
	public void setMatrixColSpanMap(HashMap<String, Integer> sheetColSpan ) 
	{
		this.matrixColSpanMap = sheetColSpan;
	}
	//added by Ravindra C on 01-02-19 to write matrix error file - End

	public int getNoOfForms()
	{
		if ( objDetailMap != null && objDetailMap.get( "TOTAL_FORMS" ) != null )
		{
			return ((int) objDetailMap.get( "TOTAL_FORMS" ));
		}
		return 0;
	}

	//Added by Ravindra C on 27/12/2020 [to support json data upload] START
	/**
	 * 
	 * @return
	 */
	public HashMap<String, String> getSheetDetailMap() 
	{
		return sheetDetailMap;
	}
	//Added by Ravindra C on 27/12/2020 [to support json data upload] END
}